<br>
<br>
<br>

<div  style="text-align: center;font-size: 70px;">
SunVote Dll协议接口说明
</div>


<div  style="text-align: center;font-size: 30px;">
Ver5.1.1
</div>
<br>
<br>
<br>
<br>
<br>
<br>

<div  style="text-align: center;font-size: 30px;">
长沙中天电子设计开发有限公司
</div>

<br>

<div  style="text-align: center;font-size: 30px;">
二〇二三年十一月
</div>

<br>
<br>
<br>
<br>

文件控制：

文件名：SunVote Dll接口说明

起草人：陈定敏

最新版本作者： 陈定敏
<br>
<br>
| 文档版本 | 日期 | 作者 | 版本说明 |
|---|---|---|---|
|5.1.1| 2023年11月30日|陈定敏|1.  初始版|

<br>

[TOC]

# 系统概述



# 设计目的



# 通讯接口设计概要



# 通信方式
数据交互采取发送<-->应答的方式。应用程序发送数据到WSCmdApp，WSCmdApp收到后执行完成后回复。

应用程序没有数据发送给WSCmdApp时，需要发送心跳，WSCmdApp收到心跳后会回复心跳，用于判断与应用程序的连接状态。（配置文件中，如果启用了心跳检查，应用程序如果未按要求发送心跳，WSCmdApp会断开当前连接，重新尝试连接）

# 编程流程说明

# 回调函数部分
## 基站事件的回调

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|int mode|回调反馈数据模式|||
|const char* sInfo|回调反馈数据|根据模式解析数据||

回调接口代码：
```C++
typedef void(*HDParamCallBack)(int iBaseID, int mode, const char* sInfo);// 基站事件回调
```
设置回调代码：
```C++
extern"C" __declspec(dllexport) void SetHDParamCallBack(HDParamCallBack cb);	//设置基站事件回调
```

基站回调函数中的 mode 列表
```C++
enum class eHDParamType {
	eVoteEvent_Choice 		= 910,	//选择题模式
	eVoteEvent_TrueFalse 		= 912,	//判断题模式 
	eVoteEvent_RushAnswer 		= 914,	//抢答题模式 
	eVoteEvent_Number 		= 916,	//数字题模式 
	eVoteEvent_Bind 		= 918,	//绑定模式 
	eVoteEvent_QuickMatch 		= 920,	//基站快速配对
	
	eVoteEvent_Voice 		= 922,	//语音答题模式
	eVoteEvent_MulQuestions 	= 923,	//T2多小题模式
	eVoteEvent_TextAnswer 		= 924,	//文本填空题模式

	eVoteEvent_Examination 		= 921,	//多题模式
	eVoteEvent_Examination_pause 	= 928,	//多题模式暂停
	eVoteEvent_Examination_continue = 929,	//多题模式继续
	eVoteEvent_Examination_ok	= 927,	//多题模式键盘下发正确答案
	eVoteEvent_Examination_Copy 	= 926,	//多题模式键盘转移数据

	eVoteEvent_TestMdoe		= 931,	//异步测试模式

	eVoteEvent_CustomQuestions	= 935,	//自定义题型模式	

	eVoteEvent_Free_Question	= 943,	//自由题型模式
}
```

## 投票事件回调

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|int mode|回调反馈数据模式|||
|const char* sInfo|回调反馈数据|根据模式解析数据||

回调接口代码：
```C++
typedef void(*VoteEventCallBack)(int iBaseID, int mode, const char* sInfo);// 投票事件回调
```
设置回调代码：
```C++
extern"C" __declspec(dllexport) void SetVoteEventCallBack(VoteEventCallBack cb);	//设置投票事件回调
```

## 键盘事件回调

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|unsigned long long keySn|键盘SN|||
|float Time|反馈时间|||
|int mode|回调反馈数据模式|||
|int RxMode|预留|||
|const char* sInfo|回调反馈数据|根据模式解析数据||

回调接口代码：
```C++
typedef void(*KeyEventCallBack)(int iBaseID, unsigned long long keySn, float Time, int mode, int RxMode, const char* sInfo);// 键盘事件回调
```
设置回调代码：
```C++
extern"C" __declspec(dllexport) void SetKeyEventCallBack(KeyEventCallBack cb);	//设置键盘事件回调回调
```

## 语音事件回调

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|unsigned long long keySn|键盘SN|||
|float Time|反馈时间|||
|int mode|回调反馈数据模式|||
|USHORT voiceId|语音按键ID|||
|USHORT dataIndex|语音数据包ID|||
|const char* data|回调反馈数据|根据模式解析数据||
|USHORT dataIndex|语音数据包ID|||
|int len|语音数据长度|||
|int sampleRate| |||
|int bitsPerSample| |||
|int channel| |||
|int recFlag| |||

回调接口代码：
```C++
typedef void(*VoiceStreamEventCallBack)(int iBaseID, ULONG keySn, int mode, USHORT voiceId, USHORT dataIndex, const char* data, int len, int sampleRate, int bitsPerSample, int channel, int recFlag);//
```
设置回调代码：
```C++
extern"C" __declspec(dllexport) void SetVoiceStreamEventCallBack(VoiceStreamEventCallBack); //设置语音数据回调函数
```

# 基站参数部分
## 复位基站
函数名称：resetBase
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||

接口代码：
```C++
extern"C" __declspec(dllexport) bool resetBase(UCHAR iBaseID);
```

反馈效果：基站可以听到“滴”一声响，基站进入重启状态。

## 获取SDK Ver
函数名称：GetSDKVer
返回参数：字符串

接口代码：
```C++
extern"C" __declspec(dllexport) char* GetSDKVer();
```

返回值：函数直接返回字符串。如“0.02.63.100”。

## 退出线程释放资源
此函数在退出软件时用来是否DLL库开辟的内存资源，请谨慎使用。

函数名称：SetThread_Exit

接口代码：
```C++
extern"C" __declspec(dllexport) void SetThread_Exit(void);	//退出线程释放资源
```

## 获取基站列表
此函数用来获取当前DLL连接了多少个基站设备。

函数名称：GetHidList_len

接口代码：
```C++
extern"C" __declspec(dllexport) int GetHidList_len();
```

返回值：
| **函数返回值** | **参数说明** |  **备注** |
| --- | --- | --- |
|0|无连接基站||
|大于0 |连接基站数量||

# 投票业务部分
## 设置广播投票是标题

函数名称：Set_Custom_Title
功能：设置广播投票是标题
说明：配合广播启动业务使用

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|UCHAR Title_Len|标题字符串长度|||
|const char* Title|标题字符串|||

接口代码：
```C++
extern"C" __declspec(dllexport) bool Set_Custom_Title(
	UCHAR iBaseID, 
	UCHAR Title_Len, 
	const char* Title);
```


## 设置空闲模式功能[广播]
函数名称：EndFreeEvent
功能：设置空闲模式功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为空闲模式

接口代码：
```C++
extern"C" __declspec(dllexport) bool EndFreeEvent(void);		//空闲模式功能
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|0~32||
|int mode|模式|0||
|const char* sInfo|参数字符串|0，OK|默认空闲模式切换成功|

## 带参数进入空闲模式
函数名称：ExitEvent
功能：退出当前模式功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为空闲模式，并在回调 函数中说明是什么模式切换到空闲模式

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|int mode_ID|用户提供的当前需要的模式||websocket情况下使用|

接口代码：
```C++
//带参数进入空闲模式功能
extern"C" __declspec(dllexport) bool ExitEvent(int mode_ID);		
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|0~32||
|int mode|模式|0||
|const char* sInfo|参数字符串|X，OK|X：mode_ID和对应<br>带参数空闲模式切换成功|

## 签到
### 签到功能[广播]
函数名称：Start_Sign_in_Event
功能：签到功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为签到功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|int bindMode|签到模式| 1:指定键签到 <br> 2:PIN码签到(默认值)||
|int modifyMode|修改模式|0:不可修改 <br>1:可以修改(默认值)||
|int lessMode|迫选模式|0:(默认值）||
|int options|选项数目|10:(默认值）||
|int optionalN|可选位数|1≤N≤14 ||
|int KeyValue|指定按键键值|0:未指定[OK键签到] <br>1:1 <br>2:2 <br> 3:3 <br> 4:4 <br> 5:5 <br> 6:6 <br> 7:7 <br> 8:8 <br> 9:9 <br> 10:0 <br> 11:上键  <br> 12:下键 <br> 13:OK  <br> 14:ESC  <br> 15: Menu ||

接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_Sign_in_Event(
	int bindMode, 
	int modifyMode, 
	int lessMode, 
	int options, 
	int optionalN, 
	int KeyValue);	//开始签到功能
```
#### 样例：
样例目的：PIN签到模式，可以修改，可选位数4位
##### 启动功能部分：
```C++
Set_Custom_Title(0, 3, "TXT");	//设置自定义标题
Start_Sign_in_Event(2, 0, 0, 0, 4, 0);	//开启pin模式签到
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|918|签到模式|
|const char* sInfo|参数字符串|"OK"|成功|

##### 接收按键数据部分：

KeyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|1||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"0,1001,0,0"|"预留,按键值,预留,预留"|

##### 退出功能部分：
```C++
ExitEvent(1);	//带签到模式退出签到
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"1,OK"|1：签到绑定带参数空闲模式切换成功|

### 签到功能[指定键盘SN]
函数名称：Start_Sign_in_Event_SN
功能：签到功能[指定键盘SN]
说明：把SDK管理的指定在线键盘设置为签到功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|指定键盘SN|||
|int bindMode|签到模式| 1:指定键签到 <br> 2:PIN码签到(默认值)||
|int modifyMode|修改模式|0:不可修改 <br>1:可以修改(默认值)||
|int lessMode|迫选模式|0:(默认值）||
|int options|选项数目|10:(默认值）||
|int optionalN|可选位数|1≤N≤14 ||
|int KeyValue|指定按键键值|0:未指定[OK键签到] <br>1:1 <br>2:2 <br> 3:3 <br> 4:4 <br> 5:5 <br> 6:6 <br> 7:7 <br> 8:8 <br> 9:9 <br> 10:0 <br> 11:上键  <br> 12:下键 <br> 13:OK  <br> 14:ESC  <br> 15: Menu ||
|UCHAR Txt_Len|提示标题长度|1~16字节||
|const char* Txt|提示标题|字符串||

接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_Sign_in_Event_SN(
	UCHAR iBaseID, 
	ULONG KeySN, 
	int bindMode, 
	int modifyMode, 
	int lessMode, 
	int options, 
	int optionalN, 
	int KeyValue, 
	UCHAR Txt_Len, 
	const char* Txt);	//开始签到功能
```

#### 样例：
样例目的：PIN签到模式，可以修改，可选项数6
##### 启动功能部分：
```C++
//指定键盘开启pin模式签到，带自定义标题
Start_Sign_in_Event_SN(0,1837454011,2, 0, 0, 0, 4, 0, 3, "TXT");	
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|918|签到模式|
|const char* sInfo|参数字符串|"OK"|成功|

##### 接收按键数据部分：

KeyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|4||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"0,1001,0,0"|"预留,按键值,预留,预留"|


##### 退出功能部分：
```C++
ExitEvent(1);	//
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"41,OK"|1：签到模式切换空闲模式成功|

## 数字题
### 数字题功能[广播]
函数名称：Start_Number_Event
功能：数字题功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为数字功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|aswOption|按键模式|0:无规则 （S6最多16位，T2最多14位）<br>1:预留<br>2:预留<br>3:带小数位上下限（T2不支持）|
|modifyMode|修改模式|0:不可修改<br>1:可以修改(默认值)|
|secrecyMode|保密模式|0:不保密(默认值)<br>1:保密||
|digits|小数位数|0:没有小数点<br>1:一位小数点<br>2:二位小数点|
|numMin|下限|aswOption=3<br>digits=0 范围：0~65535 <br> digits=1 范围：0~6553 <br> digits=2 范围：0~655|
|numMax|上限|aswOption=3<br>digits=0 范围：0~65535 <br> digits=1 范围：0~6553 <br> digits=2 范围：0~655|

接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_Number_Event(
	int aswOption, 
	int modifyMode, 
	int secrecyMode, 
	int digits, 
	USHORT numMax, 
	USHORT numMin);	//
```

#### 样例：
样例目的：启动数字题，可以修改结果，两位小数，上限：655，下限：0
##### 启动功能部分：
```C++
Set_Custom_Title(0, 3, "TXT");	//设置自定义标题
Start_Number_Event(0, 0, 0, 2, 655, 0);	//开启启动数字题
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|916|数字题模式|
|const char* sInfo|参数字符串|"OK"|成功|

##### 接收按键数据部分：

KeyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|4||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"0,99.99,0,0"|"预留,按键值,预留,预留"|

##### 退出功能部分：
```C++
ExitEvent(4);	//带数字题模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"4,OK"|4：带数字题模式切换到空闲模式成功|


### 数字题功能[指定键盘SN]
函数名称：Start_Number_Event_SN
功能：数字题功能[指定键盘SN]
说明：把SDK管理的指定在线键盘设置为数字题功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|指定键盘SN|||
|secrecyMode|保密模式|0:不保密(默认值)<br>1:保密||
|modifyMode|修改模式|0:不可修改<br>1:可以修改(默认值)|
|aswOption|按键模式|0:无规则 （S6最多16位，T2最多14位）<br>1:预留<br>2:预留<br>3:带小数位上下限（T2不支持）|
|digits|小数位数|0:没有小数点<br>1:一位小数点<br>2:二位小数点|
|numMin|下限|aswOption=3<br>digits=0 范围：0~65535 <br> digits=1 范围：0~6553 <br> digits=2 范围：0~655|
|numMax|上限|aswOption=3<br>digits=0 范围：0~65535 <br> digits=1 范围：0~6553 <br> digits=2 范围：0~655|
|UCHAR Txt_Len|提示标题长度|1~16字节||
|Txt|提示标题|字符串，长度最多不超过16个字节|

接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_Number_Event_SN(
	UCHAR iBaseID, 
	ULONG KeySN, 
	int Moed1, 
	int Moed2, 
	int Moed3, 
	int digits, 
	USHORT numMax, 
	USHORT numMin, 
	UCHAR Txt_Len, 
	const char* Txt);	//
```

#### 样例：
样例目的：启动数字题，可以修改结果，两位小数，上限：655，下限：0
##### 启动功能部分：
```C++
Start_Number_Event_SN(0,1837454011,0, 0, 0, 2, 655, 0, 3, "TXT");	//开启启动数字题
```
VoteEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|301:S6<br>302:T2||
|const char* sInfo|参数字符串|S6:"投票模式,键盘SN,结果,预留,预留" <br>T2:"投票模式,键盘SN,结果"||

##### 接收按键数据部分：

KeyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|1||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"0,99.99,0,0"|"预留,按键值,预留,预留"|

##### 退出功能部分：
```C++
ExitEvent(4);	//带数字题模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"4,OK"|4：带数字题模式切换到空闲模式成功|

## 判断题
### 判断题功能[广播]
函数名称：Start_TrueFalse_Event
功能：判断题功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为判断题功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
| optionsMode    | 选项类别     | 1:True/False 对/错 </br>2:Yes/No 是/否</br> 3:√/×|
| modifyMode     | 修改模式     | 0:不可修改</br>1:可以修改(默认值)|
| secrecyMode    | 保密模式     | 0:不保密(默认值) </br> 1:保密|



接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_TrueFalse_Event(
	int Moed1 = 1, 
	int Moed2 = 0, 
	int Moed3 = 0);
```

#### 样例：
样例目的：启动判断题，可以修改结果
##### 启动功能部分：
```C++
Set_Custom_Title(0, 3, "TXT");	//设置自定义标题
Start_TrueFalse_Event(1, 1, 0);	//开启启动判断题
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|912|判断题模式|
|const char* sInfo|参数字符串|"OK"|成功|

##### 接收按键数据部分：

KeyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|5||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"0,1,0,0"|"预留,按键值,预留,预留"|

##### 退出功能部分：
```C++
ExitEvent(5);	//带判断题模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"5,OK"|5：带判断题模式切换到空闲模式成功|


### 判断题功能[指定键盘SN]
函数名称：Start_TrueFalse_Event_SN
功能：判断题功能[指定键盘SN]
说明：把SDK管理的指定在线键盘设置为判断题功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|指定键盘SN|||
| optionsMode    | 选项类别     | 1:True/False 对/错 </br>2:Yes/No 是/否</br> 3:√/×|
| modifyMode     | 修改模式     | 0:不可修改</br>1:可以修改(默认值)|
| secrecyMode    | 保密模式     | 0:不保密(默认值) </br> 1:保密|
|UCHAR Txt_Len|提示标题长度|1~16字节||
|Txt|提示标题|字符串，长度最多不超过16个字节|

接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_TrueFalse_Event_SN(
	UCHAR iBaseID, 
	ULONG KeySN, 
	int optionsMode, 
	int modifyMode, 
	int secrecyMode, 
	UCHAR Txt_Len, 
	const char* Txt);	//
```

#### 样例：
样例目的：启动判断题，可以修改结果
##### 启动功能部分：
```C++
Start_TrueFalse_Event_SN(0,1837454011,1, 1, 0, 3, "TXT");	//开启启动判断题
```
VoteEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|301:S6<br>302:T2||
|const char* sInfo|参数字符串|S6:"投票模式,键盘SN,结果,预留,预留" <br>T2:"投票模式,键盘SN,结果"||

##### 接收按键数据部分：

KeyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|5||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"0,1,0,0"|"预留,按键值,预留,预留"|

##### 退出功能部分：
```C++
ExitEvent(5);	//带判断题模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"5,OK"|5：带判断题模式切换到空闲模式成功|


## 选择题
### 选择题功能[广播]
函数名称：Start_TrueFalse_Event
功能：选择题功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为选择题功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|optionsMode|选项类别|1:显示字母(默认值) </br>2:显示数字 |
|modifyMode|修改模式|0:不可修改  </br>1:可以修改(默认值) |
|secrecyMode|保密模式|0:不保密(默认值)</br>1:保密 |
|lessMode|迫选模式| 0:可缺选(默认值) </br>1:不可缺选</br>2:允许重复输入</br>3:允许重复输入且不可缺选 |
| options|选项数目|1≤M≤10(默认值4)|
| optionalN|可选项数|1≤N≤M(默认值1)|


接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_Choice_Event(
	int optionsMode, 
	int modifyMode, 
	int secrecyMode, 
	int lessMode, 
	int options, 
	int optionalN);
```

#### 样例：
样例目的：启动选择题，字母类型，4选1，可以修改结果
##### 启动功能部分：
```C++
Set_Custom_Title(0, 3, "TXT");	//设置自定义标题
Start_Choice_Event(1, 1, 0，0, 4, 1);	//开启启动选择题
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|910|选择题模式|
|const char* sInfo|参数字符串|"OK"|成功|

##### 接收按键数据部分：

KeyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|10||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"0,A,0,0"|"预留,按键值,预留,预留"|

##### 退出功能部分：
```C++
ExitEvent(10);	//带判断题模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"5,OK"|5：带判断题模式切换到空闲模式成功|

### 选择题功能[指定键盘SN]
函数名称：Start_Choice_Event_SN
功能：选择题功能[指定键盘SN]
说明：把SDK管理的指定在线键盘设置为选择题功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|指定键盘SN|||
|optionsMode|选项类别|1:显示字母(默认值) </br>2:显示数字 |
|secrecyMode|保密模式|0:不保密(默认值)</br>1:保密 |
|modifyMode|修改模式|0:不可修改  </br>1:可以修改(默认值) |
|lessMode|迫选模式| 0:可缺选(默认值) </br>1:不可缺选</br>2:允许重复输入</br>3:允许重复输入且不可缺选 |
| options|选项数目|1≤M≤10(默认值4)|
| optionalN|可选项数|1≤N≤M(默认值1)|
|UCHAR Txt_Len|提示标题长度|1~16字节||
|Txt|提示标题|字符串，长度最多不超过16个字节|

接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_Choice_Event_SN(
	UCHAR iBaseID, 
	ULONG KeySN, 
	int optionsMode, 
	int modifyMode, 
	int secrecyMode, 
	int lessMode, 
	int options, 
	int optionalN, 
	UCHAR Txt_Len, 
	const char* Txt);
```

#### 样例：
样例目的：启动选择题，字母类型，4选1，可以修改结果
##### 启动功能部分：
```C++
Start_Choice_Event_SN(0,1837454011, 1, 1, 0，0, 4, 1, 3, "TXT");	//开启启动判断题
```
VoteEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|301:S6<br>302:T2||
|const char* sInfo|参数字符串|S6:"投票模式,键盘SN,结果,预留,预留" <br>T2:"投票模式,键盘SN,结果"||

##### 接收按键数据部分：

KeyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|10||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"0,A,0,0"|"预留,按键值,预留,预留"|

##### 退出功能部分：
```C++
ExitEvent(10);	//带选择题模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"10,OK"|10：带选择题模式切换到空闲模式成功|


## 语音题
### 语音题功能[广播]
函数名称：Start_Voice_Event
功能：语音题功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为语音题功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|recordingMode|录音模式|0:按键录音(默认值)|
|submitTimes|提交次数|0 (0：不限制, 默认值0)|
|recordingTimeLimit|预留|0|
|recordingFormat|预留|0(默认值0)|
|recordAudioFormat|音频格式|0:mp3(默认值)<br>1:实时流|


接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_Voice_Event(
	int Moed1, 
	int Time, 
	int Num, 
	int Alert, 
	int OutMode);
```

#### 样例：
样例目的：启动语音题，mp3格式
##### 启动功能部分：
```C++
Set_Custom_Title(0, 3, "TXT");	//设置自定义标题
Start_Voice_Event(0, 0, 0，0);	//开启启动语音题
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|922|语音题模式|
|const char* sInfo|参数字符串|"OK"|成功|

##### 接收按键数据部分：

VoiceStreamEventCallBackFunc 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long keySn|键盘SN|1837454011||
|int Mode|反馈数据模式|0:mp3(默认值)<br>1:实时流||
|USHORT voiceId|回话ID|答题时间内，可重复提交语音，每段语音流加一个回话ID，用于区分作答||
|USHORT dataIndex|数据包号|1开始||
|const char* data|回调反馈数据|Mode=0：反馈的是MP3文件路径 <br> Mode=1：反馈的是实时数据流||
|int len|数据长度|Base64编码后的字符串长度。应该将 "data" 通过Base64解码后得到原始的数据长度。||
|int sampleRate|音频采样率|16000||
|int bitsPerSample|音频采样精度|16||
|int channel|声道数|1|单声道|
|int recFlag|结束标志|默认为0，为1表示结束||

##### 退出功能部分：
```C++
ExitEvent(16);	//带语音题模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"16,OK"|16：带语音题模式切换到空闲模式成功|

### 语音题功能[指定键盘SN]
函数名称：Start_Voice_Event_SN
功能：语音题功能[指定键盘SN]
说明：把SDK管理的指定在线键盘设置为语音题功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|指定键盘SN|||
|recordingMode|录音模式|0:按键录音(默认值)|
|submitTimes|提交次数|0 (0：不限制, 默认值0)|
|recordingTimeLimit|预留|0|
|recordingFormat|预留|0(默认值0)|
|recordAudioFormat|音频格式|0:mp3(默认值)<br>1:实时流|
|UCHAR Txt_Len|提示标题长度|1~16字节||
|Txt|提示标题|字符串，长度最多不超过16个字节|

接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_Voice_Event_SN(
	UCHAR iBaseID, 
	ULONG KeySN, 
	int Moed1, 
	int Time, 
	int Num, 
	int Alert, 
	int OutMode, 
	UCHAR Txt_Len, 
	const char* Txt);//
```

#### 样例：
样例目的：启动语音题，mp3格式
##### 启动功能部分：
```C++
Start_Voice_Event_SN(0,1837454011, 0, 0, 0，0, 3, "TXT");	//开启启动语音题
```
VoteEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|301:S6<br>302:T2||
|const char* sInfo|参数字符串|S6:"投票模式,键盘SN,结果,预留,预留" <br>T2:"投票模式,键盘SN,结果"||

##### 接收按键数据部分：

VoiceStreamEventCallBackFunc 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long keySn|键盘SN|1837454011||
|int Mode|反馈数据模式|0:mp3(默认值)<br>1:实时流||
|USHORT voiceId|回话ID|答题时间内，可重复提交语音，每段语音流加一个回话ID，用于区分作答||
|USHORT dataIndex|数据包号|1开始||
|const char* data|回调反馈数据|Mode=0：反馈的是MP3文件路径 <br> Mode=1：反馈的是实时数据流||
|int len|数据长度|Base64编码后的字符串长度。应该将 "data" 通过Base64解码后得到原始的数据长度。||
|int sampleRate|音频采样率|16000||
|int bitsPerSample|音频采样精度|16||
|int channel|声道数|1|单声道|
|int recFlag|结束标志|默认为0，为1表示结束||

##### 退出功能部分：
```C++
ExitEvent(16);	//带语音题模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"16,OK"|16：带语音题模式切换到空闲模式成功|

## 自由题
### 自由题功能
函数名称：Start_Free_Question_Event
功能：自由题功能
说明：把SDK管理的所有基站的在线键盘设置为自由题功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|指定键盘SN|0：默认值||


接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_Free_Question_Event(
	UCHAR iBaseID, 
	ULONG KeySN);
```
#### 样例：
样例目的：启动自由题
##### 启动功能部分：
```C++
Start_Free_Question_Event(0,0);	//开启启动自由题
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|943|自由题模式|
|const char* sInfo|参数字符串|"OK"|成功|

##### 接收按键数据部分：

KeyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|10||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"0,A,0,0"|"预留,按键值,预留,预留"|

##### 退出功能部分：
```C++
ExitEvent(10);	//带自由题模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"10,OK"|10：带自由题模式切换到空闲模式成功|

## 抢答题
### 抢答题功能

函数名称：Start_Rush_Answer_Event
功能：抢答题功能
说明：把SDK管理的所有基站的在线键盘设置为抢答题功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|int rushAnswerMode| 抢答模式|0:普通抢答(默认值)|
|int Moed2| 预留|0:(默认值)|
|int modifyMode|修改模式|0:不可修改<br>1:可以修改(默认值)|


接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_Rush_Answer_Event(
	int intrushAnswerMode, 
	int Moed2, 
	int modifyMode);	//抢答
```
#### 样例：
样例目的：启动抢答题
##### 启动功能部分：
```C++
Start_Rush_Answer_Event(0, 0, 0);	//开启抢答题
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|914|抢答题模式|
|const char* sInfo|参数字符串|"OK"|成功|

##### 接收按键数据部分：

KeyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|13||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"0,1,0,0"|"预留,按键值,预留,预留"|

##### 退出功能部分：
```C++
ExitEvent(13);	//带选择题模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"13,OK"|13：带抢答题模式切换到空闲模式成功|

### 抢答题功能[指定键盘SN]
函数名称：Start_Rush_Answer_Event_SN
功能：抢答题功能[指定键盘SN]
说明：把SDK管理的指定在线键盘设置为抢答题功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|指定键盘SN|||
|int rushAnswerMode| 抢答模式|0:普通抢答(默认值)|
|int Moed2| 预留|0:(默认值)|
|int modifyMode|修改模式|0:不可修改<br>1:可以修改(默认值)|


接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_Rush_Answer_Event_SN(
	UCHAR iBaseID, 
	ULONG KeySN, 
	int rushAnswerMode, 
	int Moed2, 
	int modifyMode); //抢答模式
```

#### 样例：
样例目的：启动抢答题
##### 启动功能部分：
```C++
Start_Rush_Answer_Event_SN(0,1837454011, 0, 0, 0);	//开启抢答题
```
VoteEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|301:S6<br>302:T2||
|const char* sInfo|参数字符串|S6:"投票模式,键盘SN,结果,预留,预留" <br>T2:"投票模式,键盘SN,结果"||

##### 接收按键数据部分：

keyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|13||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"0,1,0,0"|"预留,按键值,预留,预留"|

##### 退出功能部分：
```C++
ExitEvent(13);	//带抢答题模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"13,OK"|13：带抢答题模式切换到空闲模式成功|

## 填空题
### 填空题功能

函数名称：Start_Rush_Answer_Event
功能：填空题功能
说明：把SDK管理的所有基站的在线键盘设置为填空题功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
| int optionsMode | 填空类型 | 1:任意输入(默认值) |
| int modifyMode | 修改模式|0:不可修改  </br>1:可以修改(默认值)|
| int secrecyMode | 预留 | 0: (默认值) |


接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_TextAnswer_Event(
	int optionsMode, 
	int modifyMode, 
	int secrecyMode);
```

#### 样例：
样例目的：启动抢答题
##### 启动功能部分：
```C++
Start_TextAnswer_Event(1, 1, 0);	//开启填空题
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|924|抢答题模式|
|const char* sInfo|参数字符串|"OK"|成功|

##### 接收按键数据部分：

KeyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|12||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"填空内容"||

##### 退出功能部分：
```C++
ExitEvent(12);	//带填空题模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"12,OK"|12：带填空题模式切换到空闲模式成功|


### 填空题功能[指定键盘SN]
函数名称：Start_TextAnswer_Event_SN
功能：填空题功能[指定键盘SN]
说明：把SDK管理的指定在线键盘设置为填空题功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|指定键盘SN|||
| int optionsMode | 填空类型 | 1:任意输入(默认值) |
| int modifyMode | 修改模式|0:不可修改  </br>1:可以修改(默认值)|
| int secrecyMode | 预留 | 0: (默认值) |

接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_TextAnswer_Event_SN(
	UCHAR iBaseID, 
	ULONG KeySN, 
	int optionsMode, 
	int modifyMode, 
	int secrecyMode); //填空模式
```

#### 样例：
样例目的：启动填空题
##### 启动功能部分：
```C++
Start_Rush_Answer_Event_SN(0,1837454011, 0, 0, 0);	//开启填空题
```
VoteEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|301:S6<br>302:T2||
|const char* sInfo|参数字符串|S6:"投票模式,键盘SN,结果,预留,预留" <br>T2:"投票模式,键盘SN,结果"||

##### 接收按键数据部分：

keyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|12||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"填空内容"||

##### 退出功能部分：
```C++
ExitEvent(12);	//带填空题模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"12,OK"|12：带填空题模式切换到空闲模式成功|

## 模拟测试
### 模拟测试功能[广播]
函数名称：MockTest_Event
功能：模拟测试功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为自由题功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|UCHAR iBaseID|基站ID|0~32||
|int Moed1|模式|1-报告状态<br>2-按键模拟||
|UCHAR KeyTime|按键开启时间|启动后，多少秒内随机模拟按下按键，0=马上||
|UCHAR GapTime|按键间隔时间|提交成功后，多少秒内再重新提交，模拟修改按键，0=不测试||


接口代码：
```C++
extern"C" __declspec(dllexport) bool MockTest_Event(
	UCHAR iBaseID, 
	int Moed1, 
	UCHAR KeyTime,
	UCHAR GapTime);	//模拟测试[1 报告状态]
```

#### 样例：
样例目的：启动模拟测试
##### 启动功能部分：
```C++
MockTest_Event(0, 1, 0, 0);	//开启模拟测试
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|9|模拟测试|
|const char* sInfo|参数字符串|"OK"|成功|

##### 接收按键数据部分：

KeyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|9||
|int RxMode|预留|0||
|const char* sInfo|"67,1837454011,1.0,99"|"键盘型号,键盘SN,软件版本,电压或电量"||

##### 退出功能部分：
```C++
ExitEvent(9);	//带模拟测试模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"9,OK"|9：带模拟测试模式切换到空闲模式成功|

## 异步测验
### 异步测验功能[广播]
函数名称：TestMode_Event
功能：异步测验功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为异步测验功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|UCHAR iBaseID|基站ID|0~32||
|int Moed|预留|||
|USHORT TestNum|测试题目数量|||


接口代码：
```C++
extern"C" __declspec(dllexport) bool TestMode_Event(
	UCHAR iBaseID, 
	int Moed, 
	USHORT TestNum);
```

#### 样例：
样例目的：启动异步测验，自动测试10道题目
##### 启动功能部分：
```C++
TestMode_Event(0, 0, 10);	//开启异步测验
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|14|异步测验|
|const char* sInfo|参数字符串|"OK"|成功|

##### 接收按键数据部分：

KeyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0.5||
|int mode|回调反馈数据模式|14||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"1,1,0,0"|"题目编号,按键值,预留,预留"|

##### 退出功能部分：
```C++
ExitEvent(0);	//切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"0,OK"|0：切换到空闲模式成功|

## 多题型模式
### 启动多题型模式
函数名称：Start_Multiple_Questions_Event
功能：启动多题型模式功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为启动多题型模式功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|UCHAR iBaseID|基站ID|0~32||
|USHORT EXAMNO|测验编号|||
|USHORT TOTAL|题目总数|||
|UCHAR SELMAX|单选多选缺省选项数目|||
|UCHAR QUES_MODE|题号显示类型|||
|const char* str|题号+题型类型字符串|1,1,1,1,1；2,1,1,1,4;||


接口代码：
```C++
extern"C" __declspec(dllexport) bool Start_Multiple_Questions_Event(
	UCHAR iBaseID, 
	USHORT EXAMNO, 
	USHORT TOTAL, 
	UCHAR SELMAX, 
	UCHAR QUES_MODE, 
	const char* str);
```
### 暂停多题型模式
函数名称：Pause_Multiple_Questions_Event
功能：暂停多题型模式功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为暂停多题型模式功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|UCHAR iBaseID|基站ID|0~32||

接口代码：
```C++
extern"C" __declspec(dllexport) bool Pause_Multiple_Questions_Event(UCHAR iBaseID);
```
### 继续多题型模式
函数名称：Continue_Multiple_Questions_Event
功能：启动多题型模式功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为启动多题型模式功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|UCHAR iBaseID|基站ID|0~32||
|USHORT EXAMNO|测验编号|||
|USHORT TOTAL|题目总数|||
|UCHAR SELMAX|单选多选缺省选项数目|||
|UCHAR QUES_MODE|题号显示类型|||
|const char* str|题号+题型类型字符串|1,1,1,1,1；2,1,1,1,4;||


接口代码：
```C++
extern"C" __declspec(dllexport) bool Continue_Multiple_Questions_Event(
	UCHAR iBaseID, 
	USHORT EXAMNO, 
	USHORT TOTAL, 
	UCHAR SELMAX, 
	UCHAR QUES_MODE, 
	const char* str);
```
### 正确答案下发
函数名称：Ok_Multiple_Questions_Event
功能：启动多题型模式功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为启动多题型模式功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|UCHAR iBaseID|基站ID|0~32||
|USHORT TOTAL|题目总数|||
|const char* str|答案字符串|||


接口代码：
```C++
extern"C" __declspec(dllexport) bool Ok_Multiple_Questions_Event(
	UCHAR iBaseID, 
	USHORT TOTAL, 
	char* str);
```
### 键盘数据转移
函数名称：Ok_Multiple_Questions_Event
功能：启动多题型模式功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为启动多题型模式功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|键盘SN|||
|USHORT EXAMNO|测验编号|||
|USHORT TOTAL|题目总数|||
|const char* str|答案字符串|||


接口代码：
```C++
extern"C" __declspec(dllexport) bool Copy_Multiple_Questions_Event(
	UCHAR iBaseID, 
	ULONG KeySN, 
	USHORT EXAMNO, 
	USHORT TOTAL, 
	char* str);
```
## 自定义题型
### 自定义题型
函数名称：Custom_Questions_Event
功能：启动自定义题型功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为启动自定义题型功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|UCHAR iBaseID|基站ID|0~32||
|const char* sInfo|题目字符串|||


接口代码：
```C++
extern"C" __declspec(dllexport) bool Custom_Questions_Event(
	UCHAR iBaseID, 
	const char* sInfo);
```
## 快速配对
### 开启快速配对功能[广播]
函数名称：QuickMatch
功能：开启快速配对功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为开启快速配对功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|UCHAR iBaseID|基站ID|0~32||

接口代码：
```C++
extern"C" __declspec(dllexport) bool QuickMatch(UCHAR iBaseID);
```

#### 样例：
样例目的：启动快速配对
##### 启动功能部分：
```C++
QuickMatch(1);	//开启快速配对
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|40|快速配对|
|const char* sInfo|参数字符串|"OK"|成功|



##### 退出功能部分：
```C++
ExitEvent(40);	//快速配对模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"40,OK"|40：快速配对模式切换到空闲模式成功|

### 开启快速配对功能[内部接口]
函数名称：QuickMatch_Pro
功能：开启快速配对功能[广播]
说明：把SDK管理的所有基站的在线键盘设置为开启快速配对功能模式

| **参数名称** | **参数说明** | **范围** | **备注** |
|---|---|---|---|
|UCHAR iBaseID|基站ID|0~32||
|UCHAR Mode|配对模式|||
|UCHAR Chan|信道|||
|USHORT Id|键盘起始ID|||


接口代码：
```C++
extern"C" __declspec(dllexport) bool QuickMatch_Pro(
	UCHAR iBaseID, 
	UCHAR Mode, 
	UCHAR Chan, 
	USHORT Id); //开启快速配对生产模式
```

#### 样例：
样例目的：启动快速配对
##### 启动功能部分：
```C++
QuickMatch_Pro(1，4, 10, 1);	//开启快速配对
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|40|快速配对|
|const char* sInfo|参数字符串|"OK"|成功|



##### 退出功能部分：
```C++
ExitEvent(40);	//快速配对模式切换到空闲模式
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|0||
|const char* sInfo|参数字符串|"40,OK"|40：快速配对模式切换到空闲模式成功|

# 键盘设置
## 键盘自定义姓名
### 设置键盘自定义姓名
函数名称：SetKeyNameTxt
功能：设置键盘自定义姓名，B200 5.8G+T2、B200 2.4G+S6或B100+S6键盘自定义姓名
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|键盘SN| ||
|UCHAR Cont|操作类型|0:不操作<br>1:清除<br>2:写入||
|UCHAR Name_Len|姓名字符串长度| ||
|const char* Name|姓名字符串| ||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyNameTxt(
	UCHAR iBaseID, 
	ULONG KeySN, 
	UCHAR Cont, 
	UCHAR Name_Len, 
	const char *Name);
```

#### 样例：
样例目的：设置键盘自定义姓名
##### 启动功能部分：
```C++
SetKeyNameTxt(1，1837454011, 2, "张三");	//设置键盘自定义姓名
```
keyEventCallBack 回调接口反馈数据解析：

###### B200 2.4G + S6 或 B100 2.4G + S6

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|303||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,1,1,0"|"状态,预留,键盘自定义姓名模式,预留"|

###### B200 5.8G + T2

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|300<br>304||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,0,2,0"<br>"2,0,5,0"|"状态,预留,键盘自定义姓名模式,预留"|

## 键盘自定义姓名[C100B+S6]
### 设置C100B+S6键盘自定义姓名
函数名称：SetKeyNameTxt_C100B_S6
功能：设置键盘自定义姓名，C100B+S6键盘自定义姓名
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|键盘SN| ||
|UCHAR Name_Len|姓名字符串长度| ||
|const char* Name|姓名字符串| ||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyNameTxt_C100B_S6(
	UCHAR iBaseID, 
	ULONG KeySN, 
	UCHAR Name_Len, 
	const char* Name);
```
#### 样例：
样例目的：设置C100B+S6键盘自定义姓名
##### 启动功能部分：
```C++
SetKeyNameTxt_C100B_S6(1，1837454011, 2, "张三");	//设置键盘自定义姓名
```
##### keyEventCallBack 回调接口反馈数据解析：

###### C100B 2.4G + S6

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|306||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"张三,OK,0,0"|"姓名,状态,预留,预留"|

### 获取C100B+S6键盘自定义姓名
函数名称：GetKeyNameTxt_C100B_S6
功能：获取键盘自定义姓名，C100B+S6键盘自定义姓名
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|键盘SN| ||

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetKeyNameTxt_C100B_S6(
	UCHAR iBaseID, 
	ULONG KeySN);
```
#### 样例：
样例目的：获取C100B+S6键盘自定义姓名
#### 启动功能部分：
```C++
GetKeyNameTxt_C100B_S6(1，1837454011);	//获取键盘自定义姓名
```
keyEventCallBack 回调接口反馈数据解析：

###### C100B 2.4G + S6

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|306||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"张三,OK,0,0"|"姓名,状态,预留,预留"|


## 设置键盘评分[积分]
函数名称：SetKeyScore
功能：设置键盘评分[积分]
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|键盘SN| ||
|UCHAR Cont|操作类型|0:不操作<br>1:清除<br>2:字符串模式<br>3:五角星模式<br>4:爱心[S6有效]<br>5:写测验题分数[S6有效]||
|UCHAR Score_Len|积分字符串长度| ||
|char* Score|积分字符串| ||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyScore(
	UCHAR iBaseID, 
	ULONG KeySN, 
	UCHAR Cont, 
	UCHAR Score_Len, 
	char* Score);
```

### 样例：
样例目的：设置键盘评分[积分]
#### 启动功能部分：
```C++
SetKeyScore(1，1837454011, 2, 2, "99");	//设置键盘评分[积分]
```
#### keyEventCallBack 回调接口反馈数据解析：

##### B200 2.4G + S6 或 B100 2.4G + S6

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|303||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,1,3,0"|"状态,预留,键盘评分[积分]模式,预留"|

##### B200 5.8G + T2

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|300<br>304||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,0,9,0"<br>"2,0,13,0"|"状态,预留,键盘评分[积分]模式,预留"|

## 键盘自定义标题字符串[第二行]
函数名称：SetKeyTitleTxt2
功能：设置键盘自定义标题字符串[第二行]
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|键盘SN| ||
|UCHAR Cont|操作类型|0:不操作<br>1:清除<br>2:写入||
|UCHAR Mode|操作类型|0:空闲模式[仅T2有效]<br>1:工作模式||
|UCHAR Txt_Len|字符串长度| ||
|const char* Txt|字符串| ||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyTitleTxt2(
	UCHAR iBaseID, 
	ULONG KeySN, 
	UCHAR Cont, 
	UCHAR Mode, 
	UCHAR Txt_Len, 
	const char* Txt);
```

### 样例：
样例目的：设置键盘自定义标题字符串[第二行]
#### 启动功能部分：
```C++
SetKeyTitleTxt2(1，1837454011, 2, 1, 2, "第二行文本");	//设置键盘自定义标题字符串[第二行]
```
keyEventCallBack 回调接口反馈数据解析：

##### B200 2.4G + S6 或 B100 2.4G + S6

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|303||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,1,11,0"|"状态,预留,第二行文本模式,预留"|

##### B200 5.8G + T2

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|300<br>304||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,0,16,0"<br>"2,0,17,0"|"状态,预留,第二行文本模式,预留"|

## 键盘自定义标题字符串[第三行]
函数名称：SetKeyTitleTxt3
功能：设置键盘自定义标题字符串[第三行]
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|键盘SN| ||
|UCHAR Cont|操作类型|0:不操作<br>1:清除<br>2:写入||
|UCHAR Txt_Len|字符串长度| ||
|const char* Txt|字符串| ||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyTitleTxt3(
	UCHAR iBaseID, 
	ULONG KeySN, 
	UCHAR Cont, 
	UCHAR Txt_Len, 
	const char* Txt);
```

## 键盘自定义评分[积分]和标题字符串[第二行]
函数名称：SetKeyScreTxt2
功能：设置键盘自定义评分[积分]和标题字符串[第二行]
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|键盘SN| ||
|UCHAR Score_Type|操作类型|0:不操作<br>1:清除<br>2:字符串模式<br>3:五角星模式<br>4:爱心[S6有效]<br>5:写测验题分数[S6有效]||
|UCHAR Score_Len|字符串长度| ||
|char* Score|字符串| ||
|UCHAR Txt_Cont|操作类型|0:不操作<br>1:清除<br>2:写入||
|UCHAR Txt_Len|字符串长度| ||
|const char* Txt|字符串| ||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyScreTxt2(
	UCHAR iBaseID, 
	ULONG KeySN, 
	UCHAR Score_Type, 
	UCHAR Score_Len, 
	char* Score, 
	UCHAR Txt_Cont, 
	UCHAR Txt_Len, 
	const char* Txt);
```

## 键盘自定义短信
函数名称：SetKeyMessage
功能：设置键盘自定义短信
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN|键盘SN| ||
|const char* Txt|字符串| ||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyMessage(
	UCHAR iBaseID, 
	ULONG KeySN, 
	const char* Txt);
```

### 样例：
样例目的：设置键盘自定义短信
#### 启动功能部分：
```C++
SetKeyMessage(1，1837454011, "短信文本");	//设置键盘自定义短信
```
keyEventCallBack 回调接口反馈数据解析：

##### B200 2.4G + S6 或 B100 2.4G + S6

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|303||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,1,60,0"|"状态,预留,短信文,预留"|

## 键盘功能提示预设
设置功能提示预设
函数名称：SetKeyFunPromptPresetTxt
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|ULONG KeySN|键盘SN||
|UCHAR mode|模式||
|UCHAR type|类型||
|UCHAR Txt_Len|字符串长度||
|const char* Txt|字符串||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyFunPromptPresetTxt(
	UCHAR iBaseID, 
	ULONG KeySN, 
	UCHAR mode, 
	UCHAR type, 
	UCHAR Txt_Len, 
	const char* Txt);
```

### 样例：
样例目的：设置功能提示预设
```C++
SetKeyFunPromptPresetTxt(1，1837454011， 0, 1, 4， "提交成功");	//设置功能提示预设
```
keyEventCallBack 回调接口反馈数据解析：

B200 2.4G + S6 或 B100 2.4G + S6

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|303||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,1,52,0"|"状态,预留,功能提示预设模式,预留"|

## 键盘暂停休眠时间

设置键盘暂停休眠时间
函数名称：Key_Pause_Sleep
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|UCHAR Time|休眠时间| 0：10秒[默认]||

接口代码：
```C++
extern"C" __declspec(dllexport) bool Key_Pause_Sleep(UCHAR iBaseID, UCHAR Time);// 
```

### 样例：
样例目的：设置键盘暂停休眠时间 10秒
```C++
Key_Pause_Sleep(0, 0);	//设置键盘暂停休眠时间 10秒

```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|53|键盘暂停休眠时间|
|const char* sInfo|参数字符串|"0"|键盘暂停休眠时间 10秒|

## 键盘关机时间等级设置

### 获取键盘关机时间等级
函数名称：GetKeyboardAutoPowerOffLevel
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetKeyboardAutoPowerOffLevel(UCHAR iBaseID);
```

样例：
样例目的：获取键盘关机时间等级
```C++
GetKeyboardAutoPowerOffLevel(1);	//获取键盘关机时间等级
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|202|基站特征参数|
|const char* sInfo|参数字符串|"A，B，C，D，E，F，G，H，I"|A:预留<br>B:预留<br>C:键盘关机时间等级<br>D:心跳开关<br>E:键盘登录菜单<br>F:预留<br>G:键盘考勤发送次数<br>H:预留<br>I:键盘考勤发送功率|

### 设置键盘关机时间等级
函数名称：SetKeyboardAutoPowerOffLevel
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|UCHAR Level|关机时间等级|0:30秒<br>1:2分钟<br>2:15分钟<br>3:45分钟<br>255：不自动关机||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyboardAutoPowerOffLevel(UCHAR iBaseID, UCHAR Level);
```

样例：
样例目的：获取键盘关机时间等级
```C++
SetKeyboardAutoPowerOffLevel(1,255);	//设置键盘关机时间等级
```
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|202|基站特征参数|
|const char* sInfo|参数字符串|"A，B，C，D，E，F，G，H，I"|A:预留<br>B:预留<br>C:键盘关机时间等级<br>D:心跳开关<br>E:键盘登录菜单<br>F:预留<br>G:键盘考勤发送次数<br>H:预留<br>I:键盘考勤发送功率|

## 键盘外设操作[仅T2有效]

设置键盘外设操作[仅T2有效]
函数名称：SetKeyPeripheral
参数说明：写键盘外设,由led灯、蜂鸣器、马达组合

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
| UCHAR iBaseID|基站ID|0~32||
| ULONG keySn | 键盘SN |空字符串，为所有在线键盘|
| UCHAR LED_CTRL | Led功能使能 | 0：关闭 1：开启|
| UCHAR ledTimes | Led灯闪烁次数 | 0~255 (0是马上灭，255是长亮)|
| UCHAR ledOnTime | Led灯每次开时间 |0~255 (单位0.1s)|
| UCHAR ledOffTime | Led灯每次关时间 |0~255 (单位0.1s，为0就是连续亮)|
| UCHAR ledColorR | Led灯灯颜色,红值 |0~255(现只支持0灭和1亮,，>1也认为是1)|
| UCHAR ledColorG | Led灯灯颜色,绿值 |0~255(现只支持0灭和1亮,，>1也认为是1)|
| UCHAR edColorB | Led灯灯颜色,蓝值 |0~255(现只支持0灭和1亮,，>1也认为是1)|
| UCHAR BEEP_CTRL | 蜂鸣器功能使能 | 0：关闭 1：开启|
| UCHAR beepTimes | 蜂鸣器响次数 | 0~255 (0是马上响，255是长响) |
| UCHAR beepOnTime | 蜂鸣器每次开时间 |0~255 (单位0.1s)|
| beepOffTime | 蜂鸣器每次关时间 |0~255 (单位0.1s，为0就是连续响)|
| UCHAR MOTO_CTRL | 马达震动功能使能 | 0：关闭 1：开启|
| UCHAR motorTimes |马达震动次数|0~255|
| UCHAR motorOnTime | 马达每次开时间 |0~255 (单位0.1s)|
| UCHAR motorOffTime | 马达每次关时间 |0~255 (单位0.1s，为0就是连续振动)|

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyPeripheral(
	UCHAR iBaseID, 
	ULONG KeySN,
	UCHAR LED_CTRL, 
	UCHAR LED_TIMES, 
	UCHAR LED_TON, 
	UCHAR LED_TOFF, 
	UCHAR R, 
	UCHAR G, 
	UCHAR B,
	UCHAR BEEP_CTRL, 
	UCHAR BEEP_TIMES, 
	UCHAR BEEP_TON, 
	UCHAR BEEP_TOFF,
	UCHAR MOTO_CTRL, 
	UCHAR MOTO_TIMES, 
	UCHAR MOTO_TON, 
	UCHAR MOTO_TOFF);
```

### 样例：
样例目的：设置键盘外设操作[仅T2有效] led 红灯闪烁3次，震动3次。

```C++
//设置键盘外设操作[仅T2有效]
SetKeyPeripheral(1，1837454011, 1, 3, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 3, 1, 1);	
```
keyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|600||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,3"|"状态,外设控制模式"|

## 键盘遥控关机

遥控关机
函数名称：SetKeyRemoteShutdown
参数说明：键盘遥控关机

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
| keySn | 键盘SN |空字符串，为所有在线键盘|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyRemoteShutdown(
	UCHAR iBaseID, 
	ULONG KeySN);
```

### 样例：
样例目的：设置键盘外设操作[仅T2有效] led 红灯闪烁3次，震动3次。

```C++
//键盘遥控关机
SetKeyRemoteShutdown(1，1837454011);	
```
keyEventCallBack 回调接口反馈数据解析：

B200 2.4G + S6 或 B100 2.4G + S6

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|303||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,0,40,0"|"状态，预留,遥控关机模式，预留"|

B200 5.8G + T2

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|304||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,0,4,0"|"状态，预留,遥控关机模式，预留"|

## 键盘ID遥控关机生产模式

键盘ID遥控关机生产模式
函数名称：SetKeyRemoteShutdown_Pro
参数说明：键盘遥控关机

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|UCHAR Mode| 模式 |0~255;0:正常关机 255：一直遥控开机|
|USHORT KeyIdMin| 开始编号 |1~9999；指定键盘编号范围时候的开始值|
|USHORT KeyIdMax| 结束编号 |1~9999；指定键盘编号范围时候的结束值|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyRemoteShutdown_Pro(
	UCHAR iBaseID, 
	UCHAR Mode, 
	USHORT KeyIdMin, 
	USHORT KeyIdMax);
```

### 样例：
样例目的：键盘ID遥控关机生产模式 正常关机,编号1~100。

```C++
//键盘遥控关机
SetKeyRemoteShutdown_Pro(1, 1, 100);	
```
keyEventCallBack 回调接口反馈数据解析：

B200 2.4G + S6 或 B100 2.4G + S6

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|303||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,0,40,0"|"状态，预留,遥控关机模式，预留"|

## 键盘恢复出厂设置

设置键盘恢复出厂设置
函数名称：SetKeyFactory
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
| UCHAR iBaseID|基站ID|0~32||
| ULONG KeySN | 键盘SN |空字符串，为所有在线键盘|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyFactory(
	UCHAR iBaseID, 
	ULONG KeySN);
```

### 样例：
样例目的：所有在线键盘恢复出厂设置

```C++
//所有在线键盘恢复出厂设置
SetKeyFactory(0, 0);	
```

## 显著显示表决器信息

设置显著显示表决器信息
函数名称：SetKey_SignificantlyDisplay
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
| UCHAR Mode | 显示模式 |1 大字体显示表决器编号<br>2 液晶闪烁显示，利于查找|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKey_SignificantlyDisplay(
	UCHAR iBaseID, 
	UCHAR Mode);
```

### 样例：
样例目的：所有在线键盘 大字体显示表决器编号

```C++
//所有在线键盘 大字体显示表决器编号
SetKey_SignificantlyDisplay(0, 1);	
```

## 无线修改键盘配对码（解绑）

无线修改键盘配对码（解绑）
函数名称：SetKeyUnbind
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN| 键盘SN |0：为所有在线键盘|
|const char* MatchCode| 配对码 ||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyUnbind(
	UCHAR iBaseID, 
	ULONG KeySN, 
	const char* MatchCode);
```

### 样例：
样例目的：所有在线键盘 解绑

```C++
//所有在线键盘 解绑
SetKeyUnbind(0, 0，"FFFFFFFF");	
```

keyEventCallBack 回调接口反馈数据解析：

B200 2.4G + S6 或 B100 2.4G + S6

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|303||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,0,41,0"|"状态，预留,遥改配对码模式，预留"|

## 设置OEM型号显示名称

设置OEM型号显示名称
函数名称：SetKeyOEMModel
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|ULONG KeySN| 键盘SN |0：为所有在线键盘|
|UCHAR Model_Len| OEM字符串长度 ||
|const char* Model| OEM字符串 ||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyOEMModel(
	UCHAR iBaseID, 
	ULONG KeySN, 
	UCHAR Model_Len, 
	const char* Model);//设置键盘OEM型号名称
```

### 样例：
样例目的：所有在线键盘 解绑

```C++
//所有在线键盘 设置OEM型号显示名称
SetKeyOEMModel(0, 0， 2, "T3");	
```

## 锁定键盘,解锁键盘

锁定键盘,解锁键盘
函数名称：KeySN_Manage
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32||
|UCHAR Mode|模式|4:锁定指定键盘<br>5:锁定当前在线键盘<br>6:解锁指定键盘<br>7:解锁所有锁定的键盘|
|UCHAR NUM| 键盘数组有效个数 ||
|ULONG KeySN[250]| 键盘列表数组 ||


接口代码：
```C++
extern"C" __declspec(dllexport) bool KeySN_Manage(
	UCHAR iBaseID, 
	UCHAR Mode, 
	UCHAR NUM, 
	ULONG KeySN[250]);
```

### 样例1：
样例目的：所有在线键盘 锁定

```C++
//所有在线键盘 锁定
KeySN_Manage(0, 5， 0, NULL);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|33|锁定键盘|
|const char* sInfo|参数字符串|"-99,0"|"状态，预留"|

### 样例2：
样例目的：解锁所有键盘

```C++
//所有在线键盘 锁定
KeySN_Manage(0, 7， 0, NULL);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|34|解锁键盘|
|const char* sInfo|参数字符串|"-99,0"|"状态，预留"|

## 键盘的FSN

设置键盘的FSN
函数名称：SetKeyFSN
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|ULONG KeySN_Old| 旧键盘SN ||
|ULONG KeySN_New| 新键盘SN ||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyFSN(
	UCHAR iBaseID, 
	ULONG KeySN_Old, 
	ULONG KeySN_New);
```

### 样例：
样例目的：设置在线键盘的FSN为“1837454011”

```C++
//键设置在线键盘的FSN
SetKeyFSN(1，0，1837454011);	
```
keyEventCallBack 回调接口反馈数据解析：

B200 2.4G + S6 或 B100 2.4G + S6

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|303||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,0,43,0"|"状态，预留,设置键盘SN模式，预留"|

## 键盘的出厂日期

设置键盘的出厂日期
函数名称：SetKeyDate
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|ULONG KeySN| 键盘SN ||
|UCHAR Date[12]| 出厂日期 |2022-01-01|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyDate(
	UCHAR iBaseID, 
	ULONG KeySN, 
	UCHAR Date[12]);//设置键盘的出厂日期2022-01-01
```

## 键盘的ID[S6使用]

设置键盘的ID[S6使用]
函数名称：SetKeyID
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|ULONG KeySN| 键盘SN ||
|USHORT ID| 键盘的ID ||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyID(
	UCHAR iBaseID, 
	ULONG KeySN, 
	USHORT ID);//设置键盘的ID
```

### 样例：
样例目的：设置键盘的ID

```C++
//设置键盘的ID
SetKeyID(1，1837454011，100);	
```
keyEventCallBack 回调接口反馈数据解析：

B200 2.4G + S6 或 B100 2.4G + S6

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|303||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"2,0,42,0"|"状态，预留,设置键盘ID模式，预留"|

# 基站参数设置
## 基站的设备ID

### 设置基站的设备ID
函数名称：SetDevBaseId
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|int pathAdd|USB设备地址|可以通过GetDevBaseId()获取到||
|UCHAR iBaseID|基站ID|1~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevBaseId(
	int pathAdd, 
	UCHAR iBaseID);		//设置基站的设备ID
```

样例：
样例目的：设置基站的设备ID

```C++
SetDevBaseId(0xFFFF, 1);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|201|基站读取ID 、信道、RF功率等级|
|const char* sInfo|参数字符串|"1,10，1"|"基站ID，信道,RF功率"|

### 获取基站的设备ID
函数名称：GetDevBaseId
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevBaseId(UCHAR iBaseID);			//获取基站的设备ID
```

样例：
样例目的：设置基站的设备ID

```C++
GetDevBaseId(0);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|201|基站读取ID 、信道、RF功率等级|
|const char* sInfo|参数字符串|"1,10，1"|"基站ID，信道,RF功率"|

## 基站黑名单
设置基站到基站黑名单
函数名称：SetDevBaseBlacklist
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|int pathAdd|USB设备地址|可以通过GetDevBaseId()获取到||

接口代码：
```C++
//设置基站到基站黑名单
extern"C" __declspec(dllexport) bool SetDevBaseBlacklist(int pathAdd);		
```

样例：
样例目的：将参数对应的基站设置到本地的基站黑名单列表

```C++
SetDevBaseBlacklist(XXXXX);	
```

获取基站黑名单列表
函数名称：GetDevBaseBlacklist
参数说明：

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevBaseBlacklist();					//获取基站黑名单列表
```

样例：
样例目的：将本地的基站黑名单列表载入内存

```C++
GetDevBaseBlacklist();	
```

## 基站的设备RF功率
### 设置基站的设备RF功率
函数名称：SetDevRFPWR
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR RFPWR|设备RF功率|1:低功率<br>2:中功率<br>3:高功率|

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevRFPWR(
	UCHAR iBaseID,
	UCHAR RFPWR);	//设置基站的设备RF功率
```

样例：
样例目的：设置基站的设备ID

```C++
SetDevRFPWR(0, 1);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|201|基站读取ID 、信道、RF功率等级|
|const char* sInfo|参数字符串|"1,10，1"|"基站ID，信道,RF功率"|

### 获取基站的设备RF功率
函数名称：GetDevRFPWR
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevRFPWR(UCHAR iBaseID);	//获取基站的设备RF功率
```

样例：
样例目的：获取基站的设备ID

```C++
GetDevRFPWR(0);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|201|基站读取ID 、信道、RF功率等级|
|const char* sInfo|参数字符串|"1,10，1"|"基站ID，信道,RF功率"|

## 基站信道
### 设置基站的设备信道
函数名称：SetDevCHAN
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR chans|信道数量|1~4|
|UCHAR * chan信道数组||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevCHAN(
	UCHAR iBaseID, 
	UCHAR chans, 
	UCHAR * chan);			//设置基站的设备信道
```

样例：
样例目的：设置1号基站的设备信道，信道1：0，信道2：:8

```C++
SetDevCHAN(1,2,10,18);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|206|基站频点|
|const char* sInfo|参数字符串|"2,10,18,0,0"|"信道有效数,信道1,信道2,信道3,信道4"|

### 获取基站的设备信道
函数名称：GetDevCHAN
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevCHAN(UCHAR iBaseID);
```

样例：
样例目的：获取基站的设备信道

```C++
GetDevCHAN(1);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|206|基站频点|
|const char* sInfo|参数字符串|"2,10,18,0,0"|"信道有效数,信道1,信道2,信道3,信道4"|

## 基站配对码
### 设置基站配对码
函数名称：SetDevSYSCODE
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR code[4]|配对码||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevSYSCODE(
	UCHAR iBaseID, 
	UCHAR code[4]);	//设置基站配对码
```
样例：
样例目的：获取基站的设备信道

```C++
SetDevSYSCODE(1,0xFF010203);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|5|基站配对码|
|const char* sInfo|参数字符串|"FF010203"|基站配对码|

### 获取基站配对码
函数名称：GetDevSYSCODE
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevSYSCODE(UCHAR iBaseID);	//获取基站配对码
```

样例：
样例目的：获取基站配对码

```C++
GetDevSYSCODE(1);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|5|基站配对码|
|const char* sInfo|参数字符串|"FF010203"|基站配对码|

## 基站配对模式
### 设置基站配对模式
函数名称：SetDevPairMode
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR mode|配对模式|1:固定模式<br>2:自由模式<br>3:免配对模式<br>4:配对SN号模式<br>5:自由SN号模式<br>6:免配对SN号模式<br>7:免配对同频点SN模式<br>8:白名单模式<br>9:免配对白名单模式|

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevPairMode(
	UCHAR iBaseID, 
	UCHAR mode);		//设置基站配对模式
```

样例：
样例目的：设置基站配对模式 4:配对SN号模式

```C++
SetDevPairMode(1,4);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|204|基站配对模式、基站名称（自定义）|
|const char* sInfo|参数字符串|"4,设备1"|"基站配对模式,基站名称"|


### 获取基站配对模式
函数名称：GetDevPairMode
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevPairMode(UCHAR iBaseID);			//获取基站配对模式
```

样例：
样例目的：设置基站配对模式 4:配对SN号模式

```C++
GetDevPairMode(1);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|204|基站配对模式、基站名称（自定义）|
|const char* sInfo|参数字符串|"4,设备1"|"基站配对模式,基站名称"|

## 基站名称
### 设置基站名称
函数名称：SetDevNmae
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR Len| 基站名称字符串长度 ||
|const char *Name| 基站名称字符串 ||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevNmae(
	UCHAR iBaseID, 
	UCHAR Len, 
	const char *Name);		//设置基站名称
```

样例：
样例目的：设置基站名称

```C++
SetDevNmae(1,3,"设备1");	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|204|基站配对模式、基站名称（自定义）|
|const char* sInfo|参数字符串|"4,设备1"|"基站配对模式,基站名称"|

### 获取基站名称
函数名称：GetDevNmae
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevNmae(UCHAR iBaseID);		//获取基站名称
```

样例：
样例目的：设置基站名称

```C++
GetDevNmae(1);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|204|基站配对模式、基站名称（自定义）|
|const char* sInfo|参数字符串|"4,设备1"|"基站配对模式,基站名称"|

## 基站键盘容量
### 设置基站键盘容量
函数名称：SetDevKPNUMS
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|USHORT kPnums| 键盘数量 |B200_5.8G+T2 :1~70|
|UCHAR Lock| 预留 |0：默认|

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevKPNUMS(
	UCHAR iBaseID, 
	USHORT kPnums, 
	UCHAR Lock=0);	//设置基站键盘容量
```

样例：
样例目的：设置基站键盘容量

```C++
SetDevKPNUMS(1，60,0);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|10|基站键盘容量|
|const char* sInfo|参数字符串|"60,0"|"基站键盘容量,预留"|

### 获取基站键盘容量
函数名称：GetDevKPNUMS
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevKPNUMS(UCHAR iBaseID);	//获取基站键盘容量
```

样例：
样例目的：获取基站键盘容量

```C++
GetDevKPNUMS(1);	
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|10|基站键盘容量|
|const char* sInfo|参数字符串|"60,0"|"基站键盘容量,预留"|


## 键盘登录菜单显示允许[S6适用]
### 设置键盘登录菜单显示允许[S6适用]
函数名称：SetKeyboardLoginMenu
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR OnOff| 登录模式 |0:不允许登录<br>1:允许登录|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyboardLoginMenu(
	UCHAR iBaseID, 
	UCHAR OnOff);	
```

样例：
样例目的：设置键盘登录菜单显示允许

```C++
SetKeyboardLoginMenu(1,1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|202|基站特征参数|
|const char* sInfo|参数字符串|"A，B，C，D，E，F，G，H，I"|A:预留<br>B:预留<br>C:键盘关机时间等级<br>D:心跳开关<br>E:键盘登录菜单<br>F:预留<br>G:键盘考勤发送次数<br>H:预留<br>I:键盘考勤发送功率|

### 获取键盘登录菜单显示允许[S6适用]
函数名称：GetKeyboardLoginMenu
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetKeyboardLoginMenu(UCHAR iBaseID);	
```

样例：
样例目的：获取键盘登录菜单显示允许

```C++
GetKeyboardLoginMenu(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|202|基站特征参数|
|const char* sInfo|参数字符串|"A，B，C，D，E，F，G，H，I"|A:预留<br>B:预留<br>C:键盘关机时间等级<br>D:心跳开关<br>E:键盘登录菜单<br>F:预留<br>G:键盘考勤发送次数<br>H:预留<br>I:键盘考勤发送功率|

## 键盘和基站之间开启或关闭心跳
### 设置键盘和基站之间开启或关闭心跳
函数名称：SetKeyboardHeartbeat
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR OnOff| 登录模式 |0:关闭<br>1:开启|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyboardHeartbeat(
	UCHAR iBaseID, 
	UCHAR OnOff);	
```

样例：
样例目的：设置键盘和基站之间开启或关闭心跳

```C++
SetKeyboardHeartbeat(1,1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|202|基站特征参数|
|const char* sInfo|参数字符串|"A，B，C，D，E，F，G，H，I"|A:预留<br>B:预留<br>C:键盘关机时间等级<br>D:心跳开关<br>E:键盘登录菜单<br>F:预留<br>G:键盘考勤发送次数<br>H:预留<br>I:键盘考勤发送功率|

### 获取键盘和基站之间开启或关闭心跳
函数名称：GetKeyboardHeartbeat
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetKeyboardHeartbeat(UCHAR iBaseID);	
```

样例：
样例目的：获取键盘和基站之间开启或关闭心跳

```C++
GetKeyboardHeartbeat(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|202|基站特征参数|
|const char* sInfo|参数字符串|"A，B，C，D，E，F，G，H，I"|A:预留<br>B:预留<br>C:键盘关机时间等级<br>D:心跳开关<br>E:键盘登录菜单<br>F:预留<br>G:键盘考勤发送次数<br>H:预留<br>I:键盘考勤发送功率|


## 键盘登录密码[S6适用]
### 设置键盘登录密码[S6适用]
函数名称：SetKeyboardLoginPW
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|USHORT PW| 登录密码 |范围0~9999，0：不用核对密码|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyboardLoginPW(
	UCHAR iBaseID, 
	USHORT PW);
```

样例：
样例目的：设置键盘登录密码[S6适用]

```C++
SetKeyboardLoginPW(1，1234);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|18|键盘登录密码|
|const char* sInfo|参数字符串|"1234"|键盘登录密码|

### 获取键盘登录密码[S6适用]
函数名称：GetKeyboardLoginPW
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetKeyboardLoginPW(UCHAR iBaseID);
```

样例：
样例目的：设置键盘登录密码[S6适用]

```C++
GetKeyboardLoginPW(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|18|键盘登录密码|
|const char* sInfo|参数字符串|"1234"|键盘登录密码|

## 基站手动登录开关
### 设置基站手动登录开关
函数名称：SetDevBaseManualLogin
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR OnOff| 登录模式 |0:不允许键盘查看基站信道或名称<br>1:允许键盘查看基站信道或名称|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevBaseManualLogin(
	UCHAR iBaseID, 
	UCHAR OnOff);	
```

样例：
样例目的：设置基站手动登录开关

```C++
SetDevBaseManualLogin(1，1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|19|基站手动登录开关|
|const char* sInfo|参数字符串|"1"|基站手动登录开关|

### 获取基站手动登录开关
函数名称：GetDevBaseManualLogin
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevBaseManualLogin(UCHAR iBaseID);	
```

样例：
样例目的：获取基站手动登录开关

```C++
GetDevBaseManualLogin(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|19|基站手动登录开关|
|const char* sInfo|参数字符串|"1"|基站手动登录开关|

## 基站配套的语言
### 设置基站配套的语言
函数名称：SetDevLanguage
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR Language| 语言 |0:默认<br>1:中文<br>2:英文|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevLanguage(
	UCHAR iBaseID, 
	UCHAR Language);
```

样例：
样例目的：设置基站配套的语言

```C++
SetDevLanguage(1，1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|21|基站配套的语言|
|const char* sInfo|参数字符串|"1"|中文|

### 获取基站配套的语言
函数名称：GetDevLanguage
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevLanguage(UCHAR iBaseID);
```

样例：
样例目的：获取基站配套的语言

```C++
GetDevLanguage(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|21|基站配套的语言|
|const char* sInfo|参数字符串|"1"|中文|

## 基站和键盘之间开启CRC
### 设置基站和键盘之间开启CRC
函数名称：SetDevCRC
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR CRC| 语言 |0:不启用<br>1:启用|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevCRC(
	UCHAR iBaseID, 
	UCHAR CRC);
```

样例：
样例目的：设置基站和键盘之间开启CRC

```C++
SetDevCRC(1，1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|22|基站和键盘之间开启CRC|
|const char* sInfo|参数字符串|"1"|开启|

### 获取基站和键盘之间开启CRC
函数名称：GetDevCRC
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevCRC(UCHAR iBaseID);
```

样例：
样例目的：设置基站和键盘之间开启CRC

```C++
GetDevCRC(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|22|基站和键盘之间开启CRC|
|const char* sInfo|参数字符串|"1"|开启|

## 基站软件狗功能
### 设置基站软件狗密码[内部使用]
函数名称：SetDevCRC
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR Len| 密码长度 ||
|char* buf| 密码字符串 ||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevVotePW(
	UCHAR iBaseID, 
	UCHAR Len, 
	char* buf);
```

样例：
样例目的：设置基站软件狗密码[内部使用]

```C++
SetDevVotePW(1，6，"123456");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|24|基站软件狗密码|
|const char* sInfo|参数字符串|"123456"||

### 获取基站软件狗密码[内部使用]
函数名称：GetDevVotePW
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevVotePW(UCHAR iBaseID);
```

样例：
样例目的：获取基站软件狗密码[内部使用]

```C++
GetDevVotePW(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|24|基站软件狗密码|
|const char* sInfo|参数字符串|"123456"||

### 校验基站软件狗密码
函数名称：CheckDevVotePW
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR Len| 密码长度 ||
|char* buf| 密码字符串 ||

接口代码：
```C++
extern"C" __declspec(dllexport) bool CheckDevVotePW(UCHAR iBaseID, UCHAR Len, char* buf);
```

样例：
样例目的：校验基站软件狗密码

```C++
CheckDevVotePW(1，6，"123456");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|23|校验基站软件狗密码|
|const char* sInfo|参数字符串|"1"|核对通过|


## 基站用户自定字符串

### 设置基站用户自定字符串
函数名称：SetDevUserTxt
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR id| 字符串下标 |1~2|
|UCHAR Len| 密码长度 ||
|char* buf| 密码字符串 ||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevUserTxt(
	UCHAR iBaseID, 
	UCHAR id, 
	UCHAR Len, 
	char* buf);
```

样例：
样例目的：设置基站用户自定字符串

```C++
SetDevUserTxt(1，1，6，"333444");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|25|基站用户自定字符串|
|const char* sInfo|参数字符串|"1，333444"|"序号，基站用户自定字符串"|

### 获取基站用户自定字符串
函数名称：GetDevVotePW
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR id| 字符串下标 |1~2|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevUserTxt(UCHAR iBaseID, UCHAR id);
```

样例：
样例目的：获取基站用户自定字符串

```C++
GetDevUserTxt(1，1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|25|基站用户自定字符串|
|const char* sInfo|参数字符串|"1，333444"|"序号，基站用户自定字符串"|

## 基站唯一硬件编号UID
### 获取基站唯一硬件编号UID
函数名称：GetDevUID
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevUID(UCHAR iBaseID);
```

样例：
样例目的：获取基站唯一硬件编号UID

```C++
GetDevUID(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|26|获取基站唯一硬件编号UID|
|const char* sInfo|参数字符串|"12345678"||

## 基站反馈参数设置
### 设置空闲模式-反馈参数
函数名称：SetFeedbackMode
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR Mode| 反馈模式 ||
|UCHAR KeyValue| 反馈键值 ||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetFeedbackMode(
	UCHAR iBaseID, 
	UCHAR Mode, 
	UCHAR KeyValue);
```

样例：
样例目的：设置空闲模式-反馈参数

```C++
SetFeedbackMode(1，0,1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|27|空闲模式-反馈参数|
|const char* sInfo|参数字符串|"0，1"|"模式,键值"|

### 获取空闲模式-反馈参数
函数名称：GetFeedbackMode
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR id| 字符串下标 |1~2|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetFeedbackMode(UCHAR iBaseID);
```

样例：
样例目的：获取空闲模式-反馈参数

```C++
GetFeedbackMode(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|27|空闲模式-反馈参数|
|const char* sInfo|参数字符串|"0，1"|"模式,键值"|

## 基站SN
### 设置基站SN
函数名称：SetDevBaseSn
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR SN[5]| 基站SN ||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevBaseSn(
	UCHAR iBaseID, 
	UCHAR SN[5]);
```

样例：
样例目的：设置基站SN

```C++
SetDevBaseSn(1，"1122334455");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|203|基站的型号、硬件版本、软件版本、设备SN号|
|const char* sInfo|参数字符串|"218;1;1.0.1;1112334455"|"基站的型号;硬件版本;软件版本;设备SN号"|

### 获取基站SN
函数名称：GetDevBaseSn
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevBaseSn(UCHAR iBaseID);
```

样例：
样例目的：获取基站SN

```C++
GetDevBaseSn(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|203|基站的型号、硬件版本、软件版本、设备SN号|
|const char* sInfo|参数字符串|"218;1;1.0.1;1112334455"|"基站的型号;硬件版本;软件版本;设备SN号"|

## 基站软件版本
### 获取基站软件版本
函数名称：GetDevBaseVer
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevBaseVer(UCHAR iBaseID);
```

样例：
样例目的：获取基站SN

```C++
GetDevBaseVer(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|203|基站的型号、硬件版本、软件版本、设备SN号|
|const char* sInfo|参数字符串|"218;1;1.0.1;1112334455"|"基站的型号;硬件版本;软件版本;设备SN号"|

## 基站型号
### 获取基站型号
函数名称：GetDevBaseModel
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevBaseModel(UCHAR iBaseID);
```

样例：
样例目的：获取基站SN

```C++
GetDevBaseModel(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|203|基站的型号、硬件版本、软件版本、设备SN号|
|const char* sInfo|参数字符串|"218;1;1.0.1;1112334455"|"基站的型号;硬件版本;软件版本;设备SN号"|

## 基站列表数量
### 获取基站列表数量
函数名称：GetHidList_len
返回参数： 当前SDK接入的在线设备数量

接口代码：
```C++
extern"C" __declspec(dllexport) int GetHidList_len();
```

## 快速配对模式时是否开启低功率模式
### 设置基站快速配对模式时是否开启低功率模式
函数名称：Set_QuickMatchPower
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR LoPower|低功率模式|0:不使用低功率模式<br>1:使用低功率模式|

接口代码：
```C++
extern"C" __declspec(dllexport) bool Set_QuickMatchPower(
	UCHAR iBaseID, 
	UCHAR LoPower);
```

样例：
样例目的：设置基站快速配对模式时是否开启低功率模式

```C++
Set_QuickMatchPower(1,1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|16||
|const char* sInfo|参数字符串|"1"|1:使用低功率模式|

### 获取基站快速配对模式时是否开启低功率模式
函数名称：Get_QuickMatchPower
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool Get_QuickMatchPower(UCHAR iBaseID);
```

样例：
样例目的：获取基站快速配对模式时是否开启低功率模式

```C++
Get_QuickMatchPower(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|16||
|const char* sInfo|参数字符串|"1"|1:使用低功率模式|



## 基站刷卡
### 设置NFC信息 姓名
设置设置NFC信息 姓名
函数名称：SetNFCinf
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR NameLen|姓名字符串长度||
|char* Name|姓名字符串||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetNFCinf(
	UCHAR iBaseID, 
	UCHAR NameLen, 
	char* Name);
```

样例：
样例目的：设置NFC信息 姓名

```C++
SetNFCinf(1,2,"张三");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|43||
|const char* sInfo|参数字符串|"OK"||

### 设置NFC配对码
设置设置NFC配对码
函数名称：SetNFCmatchCode
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|char* MatchCode|配对码||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetNFCmatchCode(
	UCHAR iBaseID, 
	char* MatchCode);
```

### 设置NFC清除指令
设置设置NFC清除指令
函数名称：SetNFC_Empty
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetNFC_Empty(UCHAR iBaseID);
```

样例：
样例目的：设置设置NFC清除指令

```C++
SetNFC_Empty(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|45||
|const char* sInfo|参数字符串|"OK"||

### 键盘刷卡反馈数据[主动上报]

样例：
样例目的：键盘刷卡反馈数据[主动上报]

keyEventCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **数据值** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|1||
|unsigned long long keySn|键盘SN|1837454011||
|float Time|反馈时间[秒]|0|无效|
|int mode|回调反馈数据模式|305||
|int RxMode|预留|0||
|const char* sInfo|回调反馈数据|"1,1"|"状态,键盘列表数量"|

## 考勤基站参数
### 考勤基站时钟
#### 设置考勤基站时钟
函数名称：SetDevBaseDTime
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR HOUR|时|1~24|
|UCHAR MIN|分|0~59|
|UCHAR SEC|秒|0~59|

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevBaseDTime(
	UCHAR iBaseID, 
	UCHAR HOUR, 
	UCHAR MIN, 
	UCHAR SEC);
```

样例：
样例目的：设置考勤基站时钟 1:1:1

```C++
SetDevBaseDTime(1，01,01,01);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|36||
|const char* sInfo|参数字符串|"1,1,1"|"1:1:1"|

#### 获取考勤基站时钟
函数名称：GetDevBaseDTime
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevBaseDTime(UCHAR iBaseID);
```

样例：
样例目的：获取考勤基站时钟

```C++
GetDevBaseDTime(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|36||
|const char* sInfo|参数字符串|"1,1,1"|"1:1:1"|

### 键盘考勤发送次数
#### 设置键盘考勤发送次数
函数名称：SetKeyboardAttendanceTimes
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR Number|次数||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyboardAttendanceTimes(
	UCHAR iBaseID, 
	UCHAR Number);
```

样例：
样例目的：设置键盘考勤发送次数

```C++
SetKeyboardAttendanceTimes(1,3);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|37||
|const char* sInfo|参数字符串|"3"||

#### 获取键盘考勤发送次数
函数名称：GetKeyboardAttendanceTimes
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetKeyboardAttendanceTimes(UCHAR iBaseID);
```

样例：
样例目的：获取键盘考勤发送次数

```C++
GetKeyboardAttendanceTimes(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|37||
|const char* sInfo|参数字符串|"3"||

### 键盘考勤发送功率
#### 设置键盘考勤发送功率
函数名称：SetKeyboardAttendanceTimes
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR Power|功率||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetKeyboardAttendancePower(
	UCHAR iBaseID, 
	UCHAR Power);
```

样例：
样例目的：设置键盘考勤发送功率

```C++
SetKeyboardAttendancePower(1,1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|38||
|const char* sInfo|参数字符串|"1"||


#### 获取键盘考勤发送功率
函数名称：GetKeyboardAttendancePower
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetKeyboardAttendancePower(UCHAR iBaseID);
```

样例：
样例目的：设置键盘考勤发送功率

```C++
GetKeyboardAttendancePower(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|38||
|const char* sInfo|参数字符串|"1"||

## 基站键盘名单
### 设置键盘名单
函数名称：SetWhiteList
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|const char* keylist|键盘SN列表||

接口代码：
```C++
extern"C" __declspec(dllexport) bool SetWhiteList(
	UCHAR iBaseID, 
	const char* keylist);
```

#### 样例：
样例目的：设置键盘名单

```C++
SetWhiteList(1,"1837454011,1837454012");	//
```

B200 2.4G + S6 或 B100 2.4G + S6

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|48||
|const char* sInfo|参数字符串|"1837454011,1"|"键盘SN,状态"|

B200 5.8G + T2

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|56||
|const char* sInfo|参数字符串|"1837454011,1"|"键盘SN,状态"|

### 获取键盘名单
函数名称：GetWhiteList
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetWhiteList(UCHAR iBaseID);
```

#### 样例：
样例目的：获取键盘名单

```C++
GetWhiteList(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|47||
|const char* sInfo|参数字符串|"1837454011；1837454012"|"键盘SN1；键盘SN2"|

### 删除键盘指定名单SN
函数名称：DelWhiteList
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|const char* keylist|键盘SN列表||

接口代码：
```C++
extern"C" __declspec(dllexport) bool DelWhiteList(
	UCHAR iBaseID, 
	const char* keylist);
```

#### 样例：
样例目的：删除键盘指定名单SN

```C++
DelWhiteList(1,"1837454011,1837454012");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|31||
|const char* sInfo|参数字符串|"1837454011,1"|"键盘SN,状态"|

### 增加键盘指定名单SN
函数名称：AddWhiteList
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|const char* keylist|键盘SN列表||

接口代码：
```C++
extern"C" __declspec(dllexport) bool AddWhiteList(
	UCHAR iBaseID, 
	const char* keylist);
```

#### 样例：
样例目的：增加键盘指定名单SN

```C++
AddWhiteList(1,"1837454011,1837454012");	//
```

B200 2.4G + S6 或 B100 2.4G + S6

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|48||
|const char* sInfo|参数字符串|"1837454011,1"|"键盘SN,状态"|

B200 5.8G + T2

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|56||
|const char* sInfo|参数字符串|"1837454011,1"|"键盘SN,状态"|

### 清空键盘名单
函数名称：CleWhiteList
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool CleWhiteList(UCHAR iBaseID);
```

#### 样例：
样例目的：清空键盘名单

```C++
CleWhiteList(1");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|32||
|const char* sInfo|参数字符串|"1"|"状态"|

## 基站Tcp参数
### Tcp IP
#### 设置基站Tcp IP地址
函数名称：SetDevBase_Tcp_IP
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|char* buf|IP地址|192.168.10.1|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevBase_Tcp_IP(
	UCHAR iBaseID, 
	char* buf);
```

样例：
样例目的：设置基站Tcp IP地址

```C++
SetDevBase_Tcp_IP(1,"192.168.0.100");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"1;192.168.0.100"|"模式;参数"|

#### 获取基站Tcp IP地址
函数名称：GetDevBase_Tcp_IP
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevBase_Tcp_IP(UCHAR iBaseID);
```

### Tcp MAC
#### 设置基站Tcp MAC地址
函数名称：SetDevBase_Tcp_mac
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|char* buf|mac地址|FF:FF:FF:FF:FF:FF|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevBase_Tcp_mac(
	UCHAR iBaseID, 
	char* buf);
```

样例：
样例目的：设置基站Tcp MAC地址

```C++
SetDevBase_Tcp_mac(1,"FF:FF:FF:FF:FF:FF");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"2;FF:FF:FF:FF:FF:FF"|"模式;参数"|

#### 获取基站Tcp MAC地址
函数名称：GetDevBase_Tcp_mac
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevBase_Tcp_mac(UCHAR iBaseID);
```

样例：
样例目的：获取基站Tcp MAC地址

```C++
GetDevBase_Tcp_mac(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"2;FF:FF:FF:FF:FF:FF"|"模式;参数"|

### Tcp 子网掩码
#### 设置基站Tcp 子网掩码
函数名称：SetDevBase_Tcp_mask
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|char* buf|子网掩码地址|255.255.255.0|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevBase_Tcp_mask(
	UCHAR iBaseID, 
	char* buf);
```

样例：
样例目的：设置基站Tcp 子网掩码

```C++
SetDevBase_Tcp_mask(1，"255.255.255.0");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"3;255.255.255.0"|"模式;参数"|

#### 获取基站Tcp 子网掩码
函数名称：GetDevBase_Tcp_mask
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevBase_Tcp_mask(UCHAR iBaseID);
```

样例：
样例目的：获取基站Tcp 子网掩码

```C++
GetDevBase_Tcp_mask(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"3;255.255.255.0"|"模式;参数"|

### Tcp 网关
#### 设置基站Tcp 网关
函数名称：SetDevBase_Tcp_gateway
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|char* buf|网关地址|192.168.10.1|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevBase_Tcp_gateway(
	UCHAR iBaseID, 
	char* buf);
```

样例：
样例目的：设置基站Tcp 网关

```C++
SetDevBase_Tcp_gateway(1,"192.168.10.1");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"4;192.168.10.1"|"模式;参数"|


#### 获取基站Tcp 网关
函数名称：GetDevBase_Tcp_gateway
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevBase_Tcp_gateway(UCHAR iBaseID);
```

样例：
样例目的：设置基站Tcp 网关

```C++
GetDevBase_Tcp_gateway(1");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"4;192.168.10.1"|"模式;参数"|

### Tcp DNS
#### 设置基站Tcp DNS
函数名称：SetDevBase_Tcp_dns
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|char* buf|DNS地址|114.114.114.114|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetDevBase_Tcp_dns(
	UCHAR iBaseID, 
	char* buf);
```

样例：
样例目的：设置基站Tcp DNS

```C++
SetDevBase_Tcp_dns(1,"114.114.114.114");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"5;114.114.114.114"|"模式;参数"|

#### 获取基站Tcp DNS
函数名称：GetDevBase_Tcp_dns
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetDevBase_Tcp_dns(UCHAR iBaseID);
```

样例：
样例目的：获取基站Tcp DNS

```C++
GetDevBase_Tcp_dns(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"5;114.114.114.114"|"模式;参数"|

### 服务器 IP
#### 设置服务器 IP
函数名称：SetServer_Tcp_IP
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|char* buf|DNS地址|210.98.10.124|


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetServer_Tcp_IP(
	UCHAR iBaseID, 
	char* buf);
```

样例：
样例目的：设置服务器 IP

```C++
SetServer_Tcp_IP(1,"210.98.10.124");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"6;210.98.10.124"|"模式;参数"|


#### 获取服务器 IP
函数名称：GetServer_Tcp_IP
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetServer_Tcp_IP(UCHAR iBaseID);
```

样例：
样例目的：设置服务器 IP

```C++
GetServer_Tcp_IP(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"6;210.98.10.124"|"模式;参数"|

### 服务器 DHCP和端口
#### 设置DHCP和端口
函数名称：SetServer_Tcp_Prot
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR DHCP|DHCP|自动手动|
|ULONG Server_Port|端口||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetServer_Tcp_Prot(
	UCHAR iBaseID, 
	UCHAR DHCP, 
	ULONG Server_Port);
```

样例：
样例目的：设置DHCP和端口

```C++
SetServer_Tcp_Prot(1,0,12000);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"7;0;12000"|"模式;DHCP模式;端口"|

#### 获取DHCP和端口
函数名称：GetServer_Tcp_IP
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetServer_Tcp_Prot(UCHAR iBaseID);
```

样例：
样例目的：获取DHCP和端口

```C++
GetServer_Tcp_Prot(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"7;0;12000"|"模式;DHCP模式;端口"|

### 服务器 用户名
#### 设置服务器 用户名
函数名称：SetServer_UserName
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|char* buf|用户名字符串||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetServer_UserName(
	UCHAR iBaseID, 
	char* buf);
```

样例：
样例目的：获取服务器 用户名

```C++
SetServer_UserName(1,"admin");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"8;admin"|"模式;参数"|

#### 获取服务器 用户名
函数名称：GetServer_UserName
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetServer_UserName(UCHAR iBaseID);
```

样例：
样例目的：获取服务器 用户名

```C++
GetServer_UserName(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"8;admin"|"模式;参数"|

### 服务器 密码
#### 设置服务器 密码
函数名称：SetServer_UserPW
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|char* buf|密码符串||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetServer_UserPW(
	UCHAR iBaseID, 
	char* buf);
```

样例：
样例目的：获取服务器 用户名

```C++
SetServer_UserPW(1,"123456");	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"9;123456"|"模式;参数"|


#### 获取服务器 密码
函数名称：GetServer_UserPW
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetServer_UserPW(UCHAR iBaseID);
```

样例：
样例目的：获取服务器 用户名

```C++
GetServer_UserPW(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|54||
|const char* sInfo|参数字符串|"9;123456"|"模式;参数"|

## AES参数
### AES开关设置
#### 设置AES开关
函数名称：SetAESPar
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|UCHAR par|AES开关||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetAESPar(
	UCHAR iBaseID, 
	UCHAR par);
```

样例：
样例目的：设置AES开关

```C++
SetAESPar(1,1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|55||
|const char* sInfo|参数字符串|"1"||


获取AES开关
函数名称：GetAESPar
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetAESPar(UCHAR iBaseID);
```

样例：
样例目的：设置AES开关

```C++
GetAESPar(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|55||
|const char* sInfo|参数字符串|"1"||

### AES秘钥数据
设置秘钥数据
函数名称：SetAESData
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|char* data|AES秘钥数据||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetAESData(
	UCHAR iBaseID, 
	char* data);
```

获取AES秘钥数据
函数名称：GetAESData
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetAESData(UCHAR iBaseID);
```

### AES秘钥数据复制
设置AES秘钥数据复制
函数名称：CopyBaseAES
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR destBaseID|目标基站|1~32|
|UCHAR srcBaseID|源基站|1~32|


接口代码：
```C++
extern"C" __declspec(dllexport) bool CopyBaseAES(
	UCHAR destBaseID, 
	UCHAR srcBaseID);
```

## 基站基础配置参数
### 设置基础配置参数
函数名称：SetBasicSet
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|char BootVibraton|启动震动||
|char VoteVibraton|答题开始震动||
|char Led|指示灯开关||


接口代码：
```C++
extern"C" __declspec(dllexport) bool SetBasicSet(
	UCHAR iBaseID, 
	char BootVibraton, 
	char VoteVibraton, 
	char Led);
```

样例：
样例目的：设置基础配置参数

```C++
SetBasicSet(1,1,1,1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|57||
|const char* sInfo|参数字符串|"1;1;1"|"启动震动;答题开始震动;指示灯开关"|

### 获取基础配置参数
函数名称：GetBasicSet
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool GetBasicSet(UCHAR iBaseID);
```

样例：
样例目的：设置基础配置参数

```C++
GetBasicSet(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|57||
|const char* sInfo|参数字符串|"1;1;1"|"启动震动;答题开始震动;指示灯开关"|

# 固件升级
## 基站固件升级
基站固件升级
函数名称：DevBaseFirmwareUpdate
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|char *Path|基站固件文件路径||

接口代码：
```C++
extern"C" __declspec(dllexport) bool DevBaseFirmwareUpdate(
	UCHAR iBaseID, 
	char *Path);
```

样例：
样例目的：基站固件升级

```C++
DevBaseFirmwareUpdate(1,"C:\123.bin");	//
```

开启状态反馈
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|28||
|const char* sInfo|参数字符串|"1,OK"|"开启升级;状态"|

进度状态反馈
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|28||
|const char* sInfo|参数字符串|"2,100,50,OK"|"正在升级，总进度，当前进度;状态"|

结束状态反馈
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|28||
|const char* sInfo|参数字符串|"3,OK"|"完成升级;状态"|

## 键盘固件升级
键盘固件升级
函数名称：KeyFirmwareUpdateStart
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|
|char *Path|键盘固件文件路径||

接口代码：
```C++
extern"C" __declspec(dllexport) bool KeyFirmwareUpdateStart(
	UCHAR iBaseID, 
	char* Path);
```

样例：
样例目的：键盘固件升级

```C++
KeyFirmwareUpdateStart(1,"C:\234.bin");	//
```

开启状态反馈
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|30||
|const char* sInfo|参数字符串|"11,OK"|"开启升级;状态"|

进度状态反馈
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|30||
|const char* sInfo|参数字符串|"12,100,50,OK"|"正在升级，总进度，当前进度;状态"|

结束状态反馈
HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|30||
|const char* sInfo|参数字符串|"13,OK"|"完成升级;状态"|

停止键盘固件升级
函数名称：KeyFirmwareUpdateStop
参数说明：

| **参数名称** | **参数说明** | **范围** | **备注** |
| --- | --- | --- | --- | 
|UCHAR iBaseID|基站ID|0~32|

接口代码：
```C++
extern"C" __declspec(dllexport) bool KeyFirmwareUpdateStop(UCHAR iBaseID);
```

样例：
样例目的：停止键盘固件升级

```C++
KeyFirmwareUpdateStop(1);	//
```

HDParamCallBack 回调接口反馈数据解析：

| **参数名称** | **参数说明** | **解析** | **备注** |
| --- | --- | --- | --- | 
|int iBaseID|基站ID|1||
|int mode|模式|30||
|const char* sInfo|参数字符串|"13,OK"|"停止升级;状态"|

## 异常处理

### WSCmdApp收到数据异常

WSCmdApp收到异常数据，会不做处理，并返回以下错误信息描述。

接收:
fun: "error" //功能错误
baseId: //无该值
infos:{ "funId":"F0001","code":"10002"}// 


指令样例：
```json
{
	"fun": "error",
	"infos": {
		"funId": "F0001",
		"code": "10002"
	},
	"packetTag": "1"
}
```

| **code** | **含义** |
| --- | --- | 
|10001|不能正确解析的JSON数据|
|10002|解析JSON错误|
|20001|基站未连接|
|20002|功能不支持|
|20003|基站ID为负数，应用可以不传ID，默认为0|
|20004|参数错误|
|30001|找不到对应的SN|
|40001|升级功能只能支持一个基站在线|
|50001|此功能必须指定基站ID|
|60001|此功能必须指定键盘SN|

| **funId** | **含义** |
| --- | --- | 
|F0001|基站未连接|
|F0002|读基站信道|
|F0003|写基站信道|
|F0004|读取基站baseId 、信道、RF功率等级|
|F0005|写基站baseId|
|F0006|读基站名称|
|F0007|写基站名称|
|F0008|读键盘关机时间等级|
|F0009|写键盘关机时间等级|
|F0010|读基站配对码|
|F0011|写基站配对码|
|F0012|读基站序列号|
|F0013|写基站序列号|
|F0014|读取基站的型号、硬件版本、软件版本、设备SN号|
|F0015|写基站硬件版本|
|F0016|读基站类型|
|F0017|写基站类型|
|F0018|读基站键盘容量和Lock|
|F0019|写基站键盘容量和Lock|
|F0020|读手动获取返回在线信息|
|F0021|写手动获取返回在线信息|
|F0022|读基站设备RF功率|
|F0023|写基站设备RF功率|
|F0024|基站设备配对模式或基站名称（自定义）|
|F0025|预留|
|F0026|读基站快速配对低功率模式|
|F0027|写基站快速配对低功率模式|
|F0028|读键盘登录菜单显示允许[S6适用]|
|F0029|写键盘登录菜单显示允许[S6适用]|
|F0030|读键盘登录密码[S6适用]|
|F0031|写键盘登录密码[S6适用]|
|F0032|读基站名称隐藏开关|
|F0033|写基站名称隐藏开关|
|F0034|读基站和键盘之间的心跳开关|
|F0035|写基站和键盘之间的心跳开关|
|F0036|读基站语言|
|F0037|写基站语言|
|F0038|读基站CRC|
|F0039|写基站CRC|
|F0040|写广播投票标题|
|F0041|核对投票开启密码|
|F0042|读基站获取投票开启密码|
|F0043|写基站获取投票开启密码|
|F0044|读基站用户自定义字符串|
|F0045|写基站用户自定义字符串|
|F0046|读基站UID|
|F0047|写基站UID|
|F0048|读键盘反馈模式参数|
|F0049|写键盘反馈模式参数|
|F0050|读基站当前是开启升级状态|
|F0051|写基站当前是开启升级状态|
|F0052|手动停止键盘升级状态|
|F0053|写键盘当前是开启升级状态|
|F0054|写踢出单只键盘|
|F0055|写清掉所有键盘|
|F0056|写锁定键盘|
|F0057|写解锁键盘|
|F0058|写T2键盘第二行文本【空闲模式】|
|F0059|读考勤基站时钟设置|
|F0060|写考勤基站时钟设置|
|F0061|读考勤键盘每秒发送考勤信号次数|
|F0062|写考勤键盘每秒发送考勤信号次数|
|F0063|读考勤键盘发送考勤信号功率|
|F0064|写考勤键盘发送考勤信号功率|
|F0065|写修改键盘配对码|
|F0066|写键盘功能提示预设字符串反馈|
|F0067|写空闲模式|
|F0068|单选多选带计时模式|
|F0069|判断题带计时模式|
|F0070|抢答题带计时模式|
|F0071|数字题带计时模式|
|F0072|绑定带计时模式|
|F0073|基站快速配对|
|F0074|读基站特征数据|
|F0075|遥控关机|
|F0076|读键盘在线SN|
|F0077|写基站复位|
|F0078|写键盘外设指令|
|F0079|写键盘配对码|
|F0080|写锁定键盘,解锁键盘|
|F0081|填空题模式|
|F0082|读NFC信息 姓名|
|F0083|写NFC信息 姓名|
|F0084|写NFC配对码|
|F0085|NFC清除指令|
|F0086|多题题型开始|
|F0087|多题题型暂停|
|F0088|多题题型继续上一次|
|F0089|多题题型正确答案下发|
|F0090|多题题型已答题结果转移|
|F0091|写白名单|
|F0092|读白名单|
|F0093|写基站黑名单|
|F0094|读基站黑名单|
|F0095|C100B+S6[旧款]写键盘姓名|
|F0096|C100B+S6[旧款]读键盘姓名|
|F0097|键盘暂停休眠操作|
|F0098|异步测试模式|
|F0099|Tcp参数读|
|F0100|Tcp参数写|
|F0101|自定义题型参数|
|F0102|写S6短信|
|F0103|写S6键盘FSN|
|F0104|自由题模式|
|F0105|基站AES|
|F0106|基站AES 克隆|
|F0107|基础参数配置|
|F0108|删除指定白名单SN|
|F0109|追加指定SN 到白名单|
|F0110|语音题模式|
|F0111|多题快答模式|
|F0112|快速配对模式|
|F0113|键盘测试模式|
|F0114|写入积分和第二行文本|
|F0115|写入键盘姓名|
|F0116|键盘关机时间等级|
